export const AuthorBioSuggestion = ({ name }: { name: string }) => {
  return [
    {
      id: 1,
      title: `Explore the captivating imagination of a rising literary talent, ${name}.`,
    },
    {
      id: 2,
      title: `Immerse yourself in the thought-provoking world crafted by visionary author ${name}.`,
    },
    {
      id: 3,
      title: `Discover the compelling storytelling prowess of ${name} through their debut work.`,
    },
    {
      id: 4,
      title: `Experience the unique voice and perspective of ${name} in their literary creations.`,
    },
    {
      id: 5,
      title: `Dive into the pages of ${name}'s writing and embark on a literary journey like no other.`,
    },
    {
      id: 6,
      title: `Uncover the literary genius of ${name}, captivating readers with their brilliant narratives.`,
    },
    {
      id: 7,
      title: `Indulge in the lyrical prose and evocative storytelling of acclaimed author ${name}.`,
    },
    {
      id: 8,
      title: `Get ready to be enchanted by the imaginative narratives and vivid characters brought to life by ${name}.`,
    },
    {
      id: 9,
      title: `Be captivated by the powerful storytelling and insightful observations of emerging author ${name}.`,
    },
    {
      id: 10,
      title: `Enter a world of literary brilliance with ${name}, where imagination knows no bounds.`,
    },
  ];
};

export const AuthorQuoteSuggestion = ({ name }: { name: string }) => {
  return [
    {
      id: 1,
      title: `Create a quote about the profound insights and emotional depth found in the writings of ${name}.`,
    },
    {
      id: 2,
      title: `Craft a quote that captures the essence of ${name}'s storytelling, where imagination knows no bounds.`,
    },
    {
      id: 3,
      title: `Develop a quote that highlights the unique perspective and thought-provoking narratives of ${name}.`,
    },
    {
      id: 4,
      title: `Write a quote that celebrates the literary brilliance and captivating wordsmithing of ${name}.`,
    },
    {
      id: 5,
      title: `Design a quote that pays tribute to the transformative power of ${name}'s words and ideas.`,
    },
    {
      id: 6,
      title: `Shape a quote that encapsulates the profound impact and enduring legacy of ${name}'s literary contributions.`,
    },
    {
      id: 7,
      title: `Construct a quote that reflects the artistry and poetic beauty found within ${name}'s written works.`,
    },
    {
      id: 8,
      title: `Build a quote that invites readers to embark on a journey of self-discovery through ${name}'s insightful prose.`,
    },
    {
      id: 9,
      title: `Create a quote that captures the raw emotions and poignant storytelling of ${name}'s literary creations.`,
    },
    {
      id: 10,
      title: `Craft a quote that invites readers to explore the rich tapestry of human experiences woven by ${name}.`,
    },
  ];
};
